<?php
// Disable error display in production
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

require_once("../config/connection.php");
require("../config/session.php");

// Verify CSRF token
if (!csrf_verify($_POST['csrf_token'] ?? null)) {
    header("Location: login.php?error=invalid_request");
    exit;
}

$email = get_email('email');
$password = get_str('password');

if (empty($email) || empty($password)) {
    header("Location: login.php?error=empty_fields");
    exit;
}

// Check if login is throttled
if (is_login_throttled($email)) {
    header("Location: login.php?error=too_many_attempts");
    exit;
}

// Use prepared statement to prevent SQL injection
$stmt = $mysqli->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($user = $result->fetch_assoc()) {
    if (password_verify($password, $user['password'])) {
        // Clear failed login attempts
        clear_login_attempts($email);
        
        // Regenerate session ID to prevent fixation
        regenerate_session();
        
        // Set session variables
        $_SESSION['user'] = $email;
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['login_time'] = time();
        
        header("Location: ../index.php");
        exit;
    } else {
        // Track failed login attempt
        track_failed_login($email);
        header("Location: login.php?error=login");
        exit;
    }
} else {
    // Track failed login attempt even for non-existent users
    track_failed_login($email);
    header("Location: login.php?error=login");
    exit;
}

$stmt->close();
?>
